package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{
  FindingsCount,
  LinesOfCodeCount
}
import scala.jdk.CollectionConverters.*
final case class Metrics(
    meteredLinesOfCodeCount: Optional[LinesOfCodeCount] = Optional.Absent,
    suppressedLinesOfCodeCount: Optional[LinesOfCodeCount] = Optional.Absent,
    findingsCount: Optional[FindingsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.Metrics = {
    import Metrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.Metrics
      .builder()
      .optionallyWith(
        meteredLinesOfCodeCount.map(value =>
          LinesOfCodeCount.unwrap(value): java.lang.Long
        )
      )(_.meteredLinesOfCodeCount)
      .optionallyWith(
        suppressedLinesOfCodeCount.map(value =>
          LinesOfCodeCount.unwrap(value): java.lang.Long
        )
      )(_.suppressedLinesOfCodeCount)
      .optionallyWith(
        findingsCount.map(value => FindingsCount.unwrap(value): java.lang.Long)
      )(_.findingsCount)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.Metrics.ReadOnly =
    zio.aws.codegurureviewer.model.Metrics.wrap(buildAwsValue())
}
object Metrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.Metrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.Metrics =
      zio.aws.codegurureviewer.model.Metrics(
        meteredLinesOfCodeCount.map(value => value),
        suppressedLinesOfCodeCount.map(value => value),
        findingsCount.map(value => value)
      )
    def meteredLinesOfCodeCount: Optional[LinesOfCodeCount]
    def suppressedLinesOfCodeCount: Optional[LinesOfCodeCount]
    def findingsCount: Optional[FindingsCount]
    def getMeteredLinesOfCodeCount: ZIO[Any, AwsError, LinesOfCodeCount] =
      AwsError.unwrapOptionField(
        "meteredLinesOfCodeCount",
        meteredLinesOfCodeCount
      )
    def getSuppressedLinesOfCodeCount: ZIO[Any, AwsError, LinesOfCodeCount] =
      AwsError.unwrapOptionField(
        "suppressedLinesOfCodeCount",
        suppressedLinesOfCodeCount
      )
    def getFindingsCount: ZIO[Any, AwsError, FindingsCount] =
      AwsError.unwrapOptionField("findingsCount", findingsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Metrics
  ) extends zio.aws.codegurureviewer.model.Metrics.ReadOnly {
    override val meteredLinesOfCodeCount: Optional[LinesOfCodeCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meteredLinesOfCodeCount())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.LinesOfCodeCount(value)
        )
    override val suppressedLinesOfCodeCount: Optional[LinesOfCodeCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressedLinesOfCodeCount())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.LinesOfCodeCount(value)
        )
    override val findingsCount: Optional[FindingsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.findingsCount())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.FindingsCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Metrics
  ): zio.aws.codegurureviewer.model.Metrics.ReadOnly = new Wrapper(impl)
}
