package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.Type
  ): zio.aws.codegurureviewer.model.Type = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Type.PULL_REQUEST =>
      val r = PullRequest
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Type.REPOSITORY_ANALYSIS =>
      val r = RepositoryAnalysis
      r
  }
  case object unknownToSdkVersion extends zio.aws.codegurureviewer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Type =
      software.amazon.awssdk.services.codegurureviewer.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object PullRequest extends zio.aws.codegurureviewer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Type =
      software.amazon.awssdk.services.codegurureviewer.model.Type.PULL_REQUEST
  }
  case object RepositoryAnalysis extends zio.aws.codegurureviewer.model.Type {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Type =
      software.amazon.awssdk.services.codegurureviewer.model.Type.REPOSITORY_ANALYSIS
  }
}
