package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters.*
sealed trait Severity {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.Severity
}
object Severity {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.Severity
  ): zio.aws.codegurureviewer.model.Severity = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.INFO =>
      val r = Info
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.HIGH =>
      val r = High
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Severity.CRITICAL =>
      val r = Critical
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.UNKNOWN_TO_SDK_VERSION
  }
  case object Info extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.INFO
  }
  case object Low extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.LOW
  }
  case object Medium extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.MEDIUM
  }
  case object High extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.HIGH
  }
  case object Critical extends zio.aws.codegurureviewer.model.Severity {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Severity =
      software.amazon.awssdk.services.codegurureviewer.model.Severity.CRITICAL
  }
}
