package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeReviewType(
    repositoryAnalysis: zio.aws.codegurureviewer.model.RepositoryAnalysis,
    analysisTypes: Optional[
      Iterable[zio.aws.codegurureviewer.model.AnalysisType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType = {
    import CodeReviewType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType
      .builder()
      .repositoryAnalysis(repositoryAnalysis.buildAwsValue())
      .optionallyWith(
        analysisTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.analysisTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly =
    zio.aws.codegurureviewer.model.CodeReviewType.wrap(buildAwsValue())
}
object CodeReviewType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeReviewType =
      zio.aws.codegurureviewer.model.CodeReviewType(
        repositoryAnalysis.asEditable,
        analysisTypes.map(value => value)
      )
    def repositoryAnalysis
        : zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly
    def analysisTypes
        : Optional[List[zio.aws.codegurureviewer.model.AnalysisType]]
    def getRepositoryAnalysis: ZIO[
      Any,
      Nothing,
      zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly
    ] = ZIO.succeed(repositoryAnalysis)
    def getAnalysisTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.AnalysisType
    ]] = AwsError.unwrapOptionField("analysisTypes", analysisTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType
  ) extends zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly {
    override val repositoryAnalysis
        : zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly =
      zio.aws.codegurureviewer.model.RepositoryAnalysis
        .wrap(impl.repositoryAnalysis())
    override val analysisTypes
        : Optional[List[zio.aws.codegurureviewer.model.AnalysisType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.AnalysisType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType
  ): zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly = new Wrapper(impl)
}
