package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.KMSKeyId
import scala.jdk.CollectionConverters.*
final case class KMSKeyDetails(
    kmsKeyId: Option[KMSKeyId] = None,
    encryptionOption: Option[zio.aws.codegurureviewer.model.EncryptionOption] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails = {
    import KMSKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(encryptionOption.map(value => value.unwrap))(
        _.encryptionOption
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly =
    zio.aws.codegurureviewer.model.KMSKeyDetails.wrap(buildAwsValue())
}
object KMSKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.KMSKeyDetails =
      zio.aws.codegurureviewer.model.KMSKeyDetails(
        kmsKeyId.map(value => value),
        encryptionOption.map(value => value)
      )
    def kmsKeyId: Option[KMSKeyId]
    def encryptionOption
        : Option[zio.aws.codegurureviewer.model.EncryptionOption]
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptionOption
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.EncryptionOption] =
      AwsError.unwrapOptionField("encryptionOption", encryptionOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails
  ) extends zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly {
    override val kmsKeyId: Option[KMSKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.codegurureviewer.model.primitives.KMSKeyId(value))
    override val encryptionOption
        : Option[zio.aws.codegurureviewer.model.EncryptionOption] = scala
      .Option(impl.encryptionOption())
      .map(value => zio.aws.codegurureviewer.model.EncryptionOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails
  ): zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly = new Wrapper(impl)
}
