package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{UserId, RecommendationId}
import scala.jdk.CollectionConverters.*
final case class RecommendationFeedbackSummary(
    recommendationId: Option[RecommendationId] = None,
    reactions: Option[Iterable[zio.aws.codegurureviewer.model.Reaction]] = None,
    userId: Option[UserId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary = {
    import RecommendationFeedbackSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary
      .builder()
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationId.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .optionallyWith(
        reactions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reactionsWithStrings)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly =
    zio.aws.codegurureviewer.model.RecommendationFeedbackSummary
      .wrap(buildAwsValue())
}
object RecommendationFeedbackSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.RecommendationFeedbackSummary =
      zio.aws.codegurureviewer.model.RecommendationFeedbackSummary(
        recommendationId.map(value => value),
        reactions.map(value => value),
        userId.map(value => value)
      )
    def recommendationId: Option[RecommendationId]
    def reactions: Option[List[zio.aws.codegurureviewer.model.Reaction]]
    def userId: Option[UserId]
    def getRecommendationId: ZIO[Any, AwsError, RecommendationId] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getReactions
        : ZIO[Any, AwsError, List[zio.aws.codegurureviewer.model.Reaction]] =
      AwsError.unwrapOptionField("reactions", reactions)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary
  ) extends zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly {
    override val recommendationId: Option[RecommendationId] = scala
      .Option(impl.recommendationId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.RecommendationId(value)
      )
    override val reactions
        : Option[List[zio.aws.codegurureviewer.model.Reaction]] = scala
      .Option(impl.reactions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.Reaction.wrap(item)
        }.toList
      )
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.codegurureviewer.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary
  ): zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly =
    new Wrapper(impl)
}
