package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.{TagKey, AssociationArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: AssociationArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest
      .builder()
      .resourceArn(AssociationArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.UntagResourceRequest.ReadOnly =
    zio.aws.codegurureviewer.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.UntagResourceRequest =
      zio.aws.codegurureviewer.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AssociationArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest
  ) extends zio.aws.codegurureviewer.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.codegurureviewer.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest
  ): zio.aws.codegurureviewer.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
