package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codegurureviewer.model.primitives.{
  Owner,
  StateReason,
  Arn,
  PullRequestId,
  TimeStamp,
  Name,
  AssociationArn
}
import scala.jdk.CollectionConverters.*
final case class CodeReview(
    name: Option[Name] = None,
    codeReviewArn: Option[Arn] = None,
    repositoryName: Option[Name] = None,
    owner: Option[Owner] = None,
    providerType: Option[zio.aws.codegurureviewer.model.ProviderType] = None,
    state: Option[zio.aws.codegurureviewer.model.JobState] = None,
    stateReason: Option[StateReason] = None,
    createdTimeStamp: Option[TimeStamp] = None,
    lastUpdatedTimeStamp: Option[TimeStamp] = None,
    `type`: Option[zio.aws.codegurureviewer.model.Type] = None,
    pullRequestId: Option[PullRequestId] = None,
    sourceCodeType: Option[zio.aws.codegurureviewer.model.SourceCodeType] =
      None,
    associationArn: Option[AssociationArn] = None,
    metrics: Option[zio.aws.codegurureviewer.model.Metrics] = None,
    analysisTypes: Option[
      Iterable[zio.aws.codegurureviewer.model.AnalysisType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeReview = {
    import CodeReview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeReview
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        codeReviewArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.codeReviewArn)
      .optionallyWith(
        repositoryName.map(value => Name.unwrap(value): java.lang.String)
      )(_.repositoryName)
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(sourceCodeType.map(value => value.buildAwsValue()))(
        _.sourceCodeType
      )
      .optionallyWith(
        associationArn.map(value =>
          AssociationArn.unwrap(value): java.lang.String
        )
      )(_.associationArn)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .optionallyWith(
        analysisTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.analysisTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeReview.ReadOnly =
    zio.aws.codegurureviewer.model.CodeReview.wrap(buildAwsValue())
}
object CodeReview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeReview =
      zio.aws.codegurureviewer.model.CodeReview(
        name.map(value => value),
        codeReviewArn.map(value => value),
        repositoryName.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        createdTimeStamp.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        `type`.map(value => value),
        pullRequestId.map(value => value),
        sourceCodeType.map(value => value.asEditable),
        associationArn.map(value => value),
        metrics.map(value => value.asEditable),
        analysisTypes.map(value => value)
      )
    def name: Option[Name]
    def codeReviewArn: Option[Arn]
    def repositoryName: Option[Name]
    def owner: Option[Owner]
    def providerType: Option[zio.aws.codegurureviewer.model.ProviderType]
    def state: Option[zio.aws.codegurureviewer.model.JobState]
    def stateReason: Option[StateReason]
    def createdTimeStamp: Option[TimeStamp]
    def lastUpdatedTimeStamp: Option[TimeStamp]
    def `type`: Option[zio.aws.codegurureviewer.model.Type]
    def pullRequestId: Option[PullRequestId]
    def sourceCodeType
        : Option[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly]
    def associationArn: Option[AssociationArn]
    def metrics: Option[zio.aws.codegurureviewer.model.Metrics.ReadOnly]
    def analysisTypes: Option[List[zio.aws.codegurureviewer.model.AnalysisType]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCodeReviewArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("codeReviewArn", codeReviewArn)
    def getRepositoryName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.JobState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getType: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getSourceCodeType: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("sourceCodeType", sourceCodeType)
    def getAssociationArn: ZIO[Any, AwsError, AssociationArn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getMetrics
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getAnalysisTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.AnalysisType
    ]] = AwsError.unwrapOptionField("analysisTypes", analysisTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ) extends zio.aws.codegurureviewer.model.CodeReview.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val codeReviewArn: Option[Arn] = scala
      .Option(impl.codeReviewArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val repositoryName: Option[Name] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Option[Owner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Option[zio.aws.codegurureviewer.model.ProviderType] = scala
      .Option(impl.providerType())
      .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state: Option[zio.aws.codegurureviewer.model.JobState] = scala
      .Option(impl.state())
      .map(value => zio.aws.codegurureviewer.model.JobState.wrap(value))
    override val stateReason: Option[StateReason] = scala
      .Option(impl.stateReason())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.StateReason(value)
      )
    override val createdTimeStamp: Option[TimeStamp] = scala
      .Option(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val lastUpdatedTimeStamp: Option[TimeStamp] = scala
      .Option(impl.lastUpdatedTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val `type`: Option[zio.aws.codegurureviewer.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.codegurureviewer.model.Type.wrap(value))
    override val pullRequestId: Option[PullRequestId] = scala
      .Option(impl.pullRequestId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.PullRequestId(value)
      )
    override val sourceCodeType
        : Option[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly] = scala
      .Option(impl.sourceCodeType())
      .map(value => zio.aws.codegurureviewer.model.SourceCodeType.wrap(value))
    override val associationArn: Option[AssociationArn] = scala
      .Option(impl.associationArn())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.AssociationArn(value)
      )
    override val metrics
        : Option[zio.aws.codegurureviewer.model.Metrics.ReadOnly] = scala
      .Option(impl.metrics())
      .map(value => zio.aws.codegurureviewer.model.Metrics.wrap(value))
    override val analysisTypes
        : Option[List[zio.aws.codegurureviewer.model.AnalysisType]] = scala
      .Option(impl.analysisTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.AnalysisType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ): zio.aws.codegurureviewer.model.CodeReview.ReadOnly = new Wrapper(impl)
}
