package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.{Owner, ConnectionArn, Name}
import scala.jdk.CollectionConverters.*
final case class ThirdPartySourceRepository(
    name: Name,
    connectionArn: ConnectionArn,
    owner: Owner
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository = {
    import ThirdPartySourceRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .connectionArn(ConnectionArn.unwrap(connectionArn): java.lang.String)
      .owner(Owner.unwrap(owner): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly =
    zio.aws.codegurureviewer.model.ThirdPartySourceRepository
      .wrap(buildAwsValue())
}
object ThirdPartySourceRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ThirdPartySourceRepository =
      zio.aws.codegurureviewer.model
        .ThirdPartySourceRepository(name, connectionArn, owner)
    def name: Name
    def connectionArn: ConnectionArn
    def owner: Owner
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getConnectionArn: ZIO[Any, Nothing, ConnectionArn] =
      ZIO.succeed(connectionArn)
    def getOwner: ZIO[Any, Nothing, Owner] = ZIO.succeed(owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository
  ) extends zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly {
    override val name: Name =
      zio.aws.codegurureviewer.model.primitives.Name(impl.name())
    override val connectionArn: ConnectionArn =
      zio.aws.codegurureviewer.model.primitives
        .ConnectionArn(impl.connectionArn())
    override val owner: Owner =
      zio.aws.codegurureviewer.model.primitives.Owner(impl.owner())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository
  ): zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly =
    new Wrapper(impl)
}
