package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListRecommendationFeedbackResponse(
    recommendationFeedbackSummaries: Option[
      Iterable[zio.aws.codegurureviewer.model.RecommendationFeedbackSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse = {
    import ListRecommendationFeedbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse
      .builder()
      .optionallyWith(
        recommendationFeedbackSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationFeedbackSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse
      .wrap(buildAwsValue())
}
object ListRecommendationFeedbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse =
      zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse(
        recommendationFeedbackSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendationFeedbackSummaries: Option[List[
      zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
    ]]
    def nextToken: Option[NextToken]
    def getRecommendationFeedbackSummaries: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationFeedbackSummaries",
      recommendationFeedbackSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse
  ) extends zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly {
    override val recommendationFeedbackSummaries: Option[List[
      zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
    ]] = scala
      .Option(impl.recommendationFeedbackSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.RecommendationFeedbackSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse
  ): zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly =
    new Wrapper(impl)
}
