package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  ClientRequestToken,
  AssociationArn,
  CodeReviewName
}
import scala.jdk.CollectionConverters.*
final case class CreateCodeReviewRequest(
    name: CodeReviewName,
    repositoryAssociationArn: AssociationArn,
    `type`: zio.aws.codegurureviewer.model.CodeReviewType,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest = {
    import CreateCodeReviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest
      .builder()
      .name(CodeReviewName.unwrap(name): java.lang.String)
      .repositoryAssociationArn(
        AssociationArn.unwrap(repositoryAssociationArn): java.lang.String
      )
      .`type`(`type`.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.CreateCodeReviewRequest.ReadOnly =
    zio.aws.codegurureviewer.model.CreateCodeReviewRequest.wrap(buildAwsValue())
}
object CreateCodeReviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CreateCodeReviewRequest =
      zio.aws.codegurureviewer.model.CreateCodeReviewRequest(
        name,
        repositoryAssociationArn,
        `type`.asEditable,
        clientRequestToken.map(value => value)
      )
    def name: CodeReviewName
    def repositoryAssociationArn: AssociationArn
    def `type`: zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def getName: ZIO[Any, Nothing, CodeReviewName] = ZIO.succeed(name)
    def getRepositoryAssociationArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(repositoryAssociationArn)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly
    ] = ZIO.succeed(`type`)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest
  ) extends zio.aws.codegurureviewer.model.CreateCodeReviewRequest.ReadOnly {
    override val name: CodeReviewName =
      zio.aws.codegurureviewer.model.primitives.CodeReviewName(impl.name())
    override val repositoryAssociationArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.repositoryAssociationArn())
    override val `type`
        : zio.aws.codegurureviewer.model.CodeReviewType.ReadOnly =
      zio.aws.codegurureviewer.model.CodeReviewType.wrap(impl.`type`())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest
  ): zio.aws.codegurureviewer.model.CreateCodeReviewRequest.ReadOnly =
    new Wrapper(impl)
}
