package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  TagValue,
  TagKey,
  ClientRequestToken
}
import scala.jdk.CollectionConverters.*
final case class AssociateRepositoryRequest(
    repository: zio.aws.codegurureviewer.model.Repository,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    kmsKeyDetails: Option[zio.aws.codegurureviewer.model.KMSKeyDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest = {
    import AssociateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest
      .builder()
      .repository(repository.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(kmsKeyDetails.map(value => value.buildAwsValue()))(
        _.kmsKeyDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.AssociateRepositoryRequest.ReadOnly =
    zio.aws.codegurureviewer.model.AssociateRepositoryRequest
      .wrap(buildAwsValue())
}
object AssociateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.AssociateRepositoryRequest =
      zio.aws.codegurureviewer.model.AssociateRepositoryRequest(
        repository.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value => value),
        kmsKeyDetails.map(value => value.asEditable)
      )
    def repository: zio.aws.codegurureviewer.model.Repository.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[Map[TagKey, TagValue]]
    def kmsKeyDetails
        : Option[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly]
    def getRepository: ZIO[
      Any,
      Nothing,
      zio.aws.codegurureviewer.model.Repository.ReadOnly
    ] = ZIO.succeed(repository)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKeyDetails", kmsKeyDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest
  ) extends zio.aws.codegurureviewer.model.AssociateRepositoryRequest.ReadOnly {
    override val repository
        : zio.aws.codegurureviewer.model.Repository.ReadOnly =
      zio.aws.codegurureviewer.model.Repository.wrap(impl.repository())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ClientRequestToken(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codegurureviewer.model.primitives.TagKey(
              key
            ) -> zio.aws.codegurureviewer.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyDetails
        : Option[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly] = scala
      .Option(impl.kmsKeyDetails())
      .map(value => zio.aws.codegurureviewer.model.KMSKeyDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest
  ): zio.aws.codegurureviewer.model.AssociateRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
