package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.S3BucketName
import scala.jdk.CollectionConverters.*
final case class S3RepositoryDetails(
    bucketName: Option[S3BucketName] = None,
    codeArtifacts: Option[zio.aws.codegurureviewer.model.CodeArtifacts] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails = {
    import S3RepositoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
      .builder()
      .optionallyWith(
        bucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(codeArtifacts.map(value => value.buildAwsValue()))(
        _.codeArtifacts
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly =
    zio.aws.codegurureviewer.model.S3RepositoryDetails.wrap(buildAwsValue())
}
object S3RepositoryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.S3RepositoryDetails =
      zio.aws.codegurureviewer.model.S3RepositoryDetails(
        bucketName.map(value => value),
        codeArtifacts.map(value => value.asEditable)
      )
    def bucketName: Option[S3BucketName]
    def codeArtifacts
        : Option[zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly]
    def getBucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCodeArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("codeArtifacts", codeArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ) extends zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly {
    override val bucketName: Option[S3BucketName] = scala
      .Option(impl.bucketName())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.S3BucketName(value)
      )
    override val codeArtifacts
        : Option[zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly] = scala
      .Option(impl.codeArtifacts())
      .map(value => zio.aws.codegurureviewer.model.CodeArtifacts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails
  ): zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly = new Wrapper(
    impl
  )
}
