package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{Requester, RequestId}
import scala.jdk.CollectionConverters.*
final case class RequestMetadata(
    requestId: Option[RequestId] = None,
    requester: Option[Requester] = None,
    eventInfo: Option[zio.aws.codegurureviewer.model.EventInfo] = None,
    vendorName: Option[zio.aws.codegurureviewer.model.VendorName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata = {
    import RequestMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
      .builder()
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        requester.map(value => Requester.unwrap(value): java.lang.String)
      )(_.requester)
      .optionallyWith(eventInfo.map(value => value.buildAwsValue()))(
        _.eventInfo
      )
      .optionallyWith(vendorName.map(value => value.unwrap))(_.vendorName)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly =
    zio.aws.codegurureviewer.model.RequestMetadata.wrap(buildAwsValue())
}
object RequestMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RequestMetadata =
      zio.aws.codegurureviewer.model.RequestMetadata(
        requestId.map(value => value),
        requester.map(value => value),
        eventInfo.map(value => value.asEditable),
        vendorName.map(value => value)
      )
    def requestId: Option[RequestId]
    def requester: Option[Requester]
    def eventInfo: Option[zio.aws.codegurureviewer.model.EventInfo.ReadOnly]
    def vendorName: Option[zio.aws.codegurureviewer.model.VendorName]
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getRequester: ZIO[Any, AwsError, Requester] =
      AwsError.unwrapOptionField("requester", requester)
    def getEventInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.EventInfo.ReadOnly
    ] = AwsError.unwrapOptionField("eventInfo", eventInfo)
    def getVendorName
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.VendorName] =
      AwsError.unwrapOptionField("vendorName", vendorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ) extends zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly {
    override val requestId: Option[RequestId] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.codegurureviewer.model.primitives.RequestId(value))
    override val requester: Option[Requester] = scala
      .Option(impl.requester())
      .map(value => zio.aws.codegurureviewer.model.primitives.Requester(value))
    override val eventInfo
        : Option[zio.aws.codegurureviewer.model.EventInfo.ReadOnly] = scala
      .Option(impl.eventInfo())
      .map(value => zio.aws.codegurureviewer.model.EventInfo.wrap(value))
    override val vendorName: Option[zio.aws.codegurureviewer.model.VendorName] =
      scala
        .Option(impl.vendorName())
        .map(value => zio.aws.codegurureviewer.model.VendorName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ): zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly = new Wrapper(impl)
}
