package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  BuildArtifactsObjectKey,
  SourceCodeArtifactsObjectKey
}
import scala.jdk.CollectionConverters.*
final case class CodeArtifacts(
    sourceCodeArtifactsObjectKey: SourceCodeArtifactsObjectKey,
    buildArtifactsObjectKey: Option[BuildArtifactsObjectKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts = {
    import CodeArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts
      .builder()
      .sourceCodeArtifactsObjectKey(
        SourceCodeArtifactsObjectKey.unwrap(
          sourceCodeArtifactsObjectKey
        ): java.lang.String
      )
      .optionallyWith(
        buildArtifactsObjectKey.map(value =>
          BuildArtifactsObjectKey.unwrap(value): java.lang.String
        )
      )(_.buildArtifactsObjectKey)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly =
    zio.aws.codegurureviewer.model.CodeArtifacts.wrap(buildAwsValue())
}
object CodeArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeArtifacts =
      zio.aws.codegurureviewer.model.CodeArtifacts(
        sourceCodeArtifactsObjectKey,
        buildArtifactsObjectKey.map(value => value)
      )
    def sourceCodeArtifactsObjectKey: SourceCodeArtifactsObjectKey
    def buildArtifactsObjectKey: Option[BuildArtifactsObjectKey]
    def getSourceCodeArtifactsObjectKey
        : ZIO[Any, Nothing, SourceCodeArtifactsObjectKey] =
      ZIO.succeed(sourceCodeArtifactsObjectKey)
    def getBuildArtifactsObjectKey
        : ZIO[Any, AwsError, BuildArtifactsObjectKey] = AwsError
      .unwrapOptionField("buildArtifactsObjectKey", buildArtifactsObjectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts
  ) extends zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly {
    override val sourceCodeArtifactsObjectKey: SourceCodeArtifactsObjectKey =
      zio.aws.codegurureviewer.model.primitives
        .SourceCodeArtifactsObjectKey(impl.sourceCodeArtifactsObjectKey())
    override val buildArtifactsObjectKey: Option[BuildArtifactsObjectKey] =
      scala
        .Option(impl.buildArtifactsObjectKey())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives
            .BuildArtifactsObjectKey(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeArtifacts
  ): zio.aws.codegurureviewer.model.CodeArtifacts.ReadOnly = new Wrapper(impl)
}
