package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  RuleTag,
  LongDescription,
  RuleId,
  RuleName,
  ShortDescription
}
import scala.jdk.CollectionConverters.*
final case class RuleMetadata(
    ruleId: Option[RuleId] = None,
    ruleName: Option[RuleName] = None,
    shortDescription: Option[ShortDescription] = None,
    longDescription: Option[LongDescription] = None,
    ruleTags: Option[Iterable[RuleTag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata = {
    import RuleMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
      .builder()
      .optionallyWith(
        ruleId.map(value => RuleId.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .optionallyWith(
        ruleTags.map(value =>
          value.map { item =>
            RuleTag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleTags)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly =
    zio.aws.codegurureviewer.model.RuleMetadata.wrap(buildAwsValue())
}
object RuleMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RuleMetadata =
      zio.aws.codegurureviewer.model.RuleMetadata(
        ruleId.map(value => value),
        ruleName.map(value => value),
        shortDescription.map(value => value),
        longDescription.map(value => value),
        ruleTags.map(value => value)
      )
    def ruleId: Option[RuleId]
    def ruleName: Option[RuleName]
    def shortDescription: Option[ShortDescription]
    def longDescription: Option[LongDescription]
    def ruleTags: Option[List[RuleTag]]
    def getRuleId: ZIO[Any, AwsError, RuleId] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getRuleTags: ZIO[Any, AwsError, List[RuleTag]] =
      AwsError.unwrapOptionField("ruleTags", ruleTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ) extends zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly {
    override val ruleId: Option[RuleId] = scala
      .Option(impl.ruleId())
      .map(value => zio.aws.codegurureviewer.model.primitives.RuleId(value))
    override val ruleName: Option[RuleName] = scala
      .Option(impl.ruleName())
      .map(value => zio.aws.codegurureviewer.model.primitives.RuleName(value))
    override val shortDescription: Option[ShortDescription] = scala
      .Option(impl.shortDescription())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ShortDescription(value)
      )
    override val longDescription: Option[LongDescription] = scala
      .Option(impl.longDescription())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.LongDescription(value)
      )
    override val ruleTags: Option[List[RuleTag]] = scala
      .Option(impl.ruleTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.RuleTag(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ): zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly = new Wrapper(impl)
}
