package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{EventState, EventName}
import scala.jdk.CollectionConverters.*
final case class EventInfo(
    name: Option[EventName] = None,
    state: Option[EventState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.EventInfo = {
    import EventInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.EventInfo
      .builder()
      .optionallyWith(
        name.map(value => EventName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        state.map(value => EventState.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.EventInfo.ReadOnly =
    zio.aws.codegurureviewer.model.EventInfo.wrap(buildAwsValue())
}
object EventInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.EventInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.EventInfo =
      zio.aws.codegurureviewer.model
        .EventInfo(name.map(value => value), state.map(value => value))
    def name: Option[EventName]
    def state: Option[EventState]
    def getName: ZIO[Any, AwsError, EventName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, EventState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.EventInfo
  ) extends zio.aws.codegurureviewer.model.EventInfo.ReadOnly {
    override val name: Option[EventName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.EventName(value))
    override val state: Option[EventState] = scala
      .Option(impl.state())
      .map(value => zio.aws.codegurureviewer.model.primitives.EventState(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.EventInfo
  ): zio.aws.codegurureviewer.model.EventInfo.ReadOnly = new Wrapper(impl)
}
