package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.{S3BucketName, Name}
import scala.jdk.CollectionConverters.*
final case class S3Repository(name: Name, bucketName: S3BucketName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.S3Repository = {
    import S3Repository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.S3Repository
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.S3Repository.ReadOnly =
    zio.aws.codegurureviewer.model.S3Repository.wrap(buildAwsValue())
}
object S3Repository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.S3Repository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.S3Repository =
      zio.aws.codegurureviewer.model.S3Repository(name, bucketName)
    def name: Name
    def bucketName: S3BucketName
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3Repository
  ) extends zio.aws.codegurureviewer.model.S3Repository.ReadOnly {
    override val name: Name =
      zio.aws.codegurureviewer.model.primitives.Name(impl.name())
    override val bucketName: S3BucketName =
      zio.aws.codegurureviewer.model.primitives.S3BucketName(impl.bucketName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3Repository
  ): zio.aws.codegurureviewer.model.S3Repository.ReadOnly = new Wrapper(impl)
}
