package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.AssociationArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: AssociationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AssociationArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListTagsForResourceRequest =
      zio.aws.codegurureviewer.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AssociationArn
    def getResourceArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest
  ) extends zio.aws.codegurureviewer.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest
  ): zio.aws.codegurureviewer.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
