package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.{
  TagValue,
  TagKey,
  AssociationArn
}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AssociationArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest
      .builder()
      .resourceArn(AssociationArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.TagResourceRequest.ReadOnly =
    zio.aws.codegurureviewer.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.TagResourceRequest =
      zio.aws.codegurureviewer.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: AssociationArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, AssociationArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest
  ) extends zio.aws.codegurureviewer.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AssociationArn =
      zio.aws.codegurureviewer.model.primitives
        .AssociationArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codegurureviewer.model.primitives.TagKey(
          key
        ) -> zio.aws.codegurureviewer.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest
  ): zio.aws.codegurureviewer.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
