package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRecommendationsResponse(
    recommendationSummaries: Optional[
      Iterable[zio.aws.codegurureviewer.model.RecommendationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse = {
    import ListRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse
      .builder()
      .optionallyWith(
        recommendationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationsResponse
      .wrap(buildAwsValue())
}
object ListRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListRecommendationsResponse =
      zio.aws.codegurureviewer.model.ListRecommendationsResponse(
        recommendationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendationSummaries: Optional[
      List[zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getRecommendationSummaries: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationSummaries",
      recommendationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse
  ) extends zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly {
    override val recommendationSummaries: Optional[
      List[zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.RecommendationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse
  ): zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
