package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RepositoryAnalysis(
    repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType
    ] = Optional.Absent,
    sourceCodeType: Optional[zio.aws.codegurureviewer.model.SourceCodeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis = {
    import RepositoryAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis
      .builder()
      .optionallyWith(repositoryHead.map(value => value.buildAwsValue()))(
        _.repositoryHead
      )
      .optionallyWith(sourceCodeType.map(value => value.buildAwsValue()))(
        _.sourceCodeType
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryAnalysis.wrap(buildAwsValue())
}
object RepositoryAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RepositoryAnalysis =
      zio.aws.codegurureviewer.model.RepositoryAnalysis(
        repositoryHead.map(value => value.asEditable),
        sourceCodeType.map(value => value.asEditable)
      )
    def repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ]
    def sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly]
    def getRepositoryHead: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryHead", repositoryHead)
    def getSourceCodeType: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("sourceCodeType", sourceCodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis
  ) extends zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly {
    override val repositoryHead: Optional[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryHead())
      .map(value =>
        zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.wrap(value)
      )
    override val sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeType())
        .map(value => zio.aws.codegurureviewer.model.SourceCodeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis
  ): zio.aws.codegurureviewer.model.RepositoryAnalysis.ReadOnly = new Wrapper(
    impl
  )
}
