package zio.aws.codegurureviewer
import zio.aws.codegurureviewer.model.ListCodeReviewsResponse.ReadOnly
import zio.aws.codegurureviewer.model.{
  ListCodeReviewsRequest,
  AssociateRepositoryRequest,
  ListRecommendationsRequest,
  ListTagsForResourceRequest,
  DescribeCodeReviewRequest,
  CreateCodeReviewRequest,
  PutRecommendationFeedbackRequest,
  DisassociateRepositoryRequest,
  UntagResourceRequest,
  DescribeRepositoryAssociationRequest,
  ListRecommendationFeedbackRequest,
  ListRepositoryAssociationsRequest,
  DescribeRecommendationFeedbackRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CodeGuruReviewerMock extends Mock[CodeGuruReviewer] {
  object ListRecommendations
      extends Stream[
        ListRecommendationsRequest,
        AwsError,
        zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
      ]
  object ListRecommendationsPaginated
      extends Effect[
        ListRecommendationsRequest,
        AwsError,
        zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly
      ]
  object CreateCodeReview
      extends Effect[
        CreateCodeReviewRequest,
        AwsError,
        zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly
      ]
  object AssociateRepository
      extends Effect[
        AssociateRepositoryRequest,
        AwsError,
        zio.aws.codegurureviewer.model.AssociateRepositoryResponse.ReadOnly
      ]
  object DisassociateRepository
      extends Effect[
        DisassociateRepositoryRequest,
        AwsError,
        zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly
      ]
  object DescribeCodeReview
      extends Effect[
        DescribeCodeReviewRequest,
        AwsError,
        zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly
      ]
  object ListRepositoryAssociations
      extends Stream[
        ListRepositoryAssociationsRequest,
        AwsError,
        zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
      ]
  object ListRepositoryAssociationsPaginated
      extends Effect[
        ListRepositoryAssociationsRequest,
        AwsError,
        zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly
      ]
  object ListCodeReviews
      extends Stream[
        ListCodeReviewsRequest,
        AwsError,
        zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
      ]
  object ListCodeReviewsPaginated
      extends Effect[ListCodeReviewsRequest, AwsError, ReadOnly]
  object DescribeRepositoryAssociation
      extends Effect[
        DescribeRepositoryAssociationRequest,
        AwsError,
        zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codegurureviewer.model.UntagResourceResponse.ReadOnly
      ]
  object ListRecommendationFeedback
      extends Stream[
        ListRecommendationFeedbackRequest,
        AwsError,
        zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
      ]
  object ListRecommendationFeedbackPaginated
      extends Effect[
        ListRecommendationFeedbackRequest,
        AwsError,
        zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codegurureviewer.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codegurureviewer.model.TagResourceResponse.ReadOnly
      ]
  object PutRecommendationFeedback
      extends Effect[
        PutRecommendationFeedbackRequest,
        AwsError,
        zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.ReadOnly
      ]
  object DescribeRecommendationFeedback
      extends Effect[
        DescribeRecommendationFeedbackRequest,
        AwsError,
        zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeGuruReviewer] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeGuruReviewer] { rts =>
        zio.ZIO.succeed {
          new CodeGuruReviewer {
            val api: CodeGuruReviewerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeGuruReviewer = this
            def listRecommendations(
                request: ListRecommendationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codegurureviewer.model.RecommendationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecommendations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecommendationsPaginated(
                request: ListRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.ListRecommendationsResponse.ReadOnly
            ] = proxy(ListRecommendationsPaginated, request)
            def createCodeReview(request: CreateCodeReviewRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.CreateCodeReviewResponse.ReadOnly
            ] = proxy(CreateCodeReview, request)
            def associateRepository(request: AssociateRepositoryRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.AssociateRepositoryResponse.ReadOnly
            ] = proxy(AssociateRepository, request)
            def disassociateRepository(
                request: DisassociateRepositoryRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly
            ] = proxy(DisassociateRepository, request)
            def describeCodeReview(request: DescribeCodeReviewRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly
            ] = proxy(DescribeCodeReview, request)
            def listRepositoryAssociations(
                request: ListRepositoryAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRepositoryAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRepositoryAssociationsPaginated(
                request: ListRepositoryAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly
            ] = proxy(ListRepositoryAssociationsPaginated, request)
            def listCodeReviews(request: ListCodeReviewsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCodeReviews, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCodeReviewsPaginated(
                request: ListCodeReviewsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListCodeReviewsPaginated, request)
            def describeRepositoryAssociation(
                request: DescribeRepositoryAssociationRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.DescribeRepositoryAssociationResponse.ReadOnly
            ] = proxy(DescribeRepositoryAssociation, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listRecommendationFeedback(
                request: ListRecommendationFeedbackRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codegurureviewer.model.RecommendationFeedbackSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecommendationFeedback, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecommendationFeedbackPaginated(
                request: ListRecommendationFeedbackRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.ListRecommendationFeedbackResponse.ReadOnly
            ] = proxy(ListRecommendationFeedbackPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codegurureviewer.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def putRecommendationFeedback(
                request: PutRecommendationFeedbackRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.PutRecommendationFeedbackResponse.ReadOnly
            ] = proxy(PutRecommendationFeedback, request)
            def describeRecommendationFeedback(
                request: DescribeRecommendationFeedbackRequest
            ): IO[
              AwsError,
              zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly
            ] = proxy(DescribeRecommendationFeedback, request)
          }
        }
      }
    }
  }
}
