package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  Owner,
  Arn,
  PullRequestId,
  TimeStamp,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CodeReviewSummary(
    name: Optional[Name] = Optional.Absent,
    codeReviewArn: Optional[Arn] = Optional.Absent,
    repositoryName: Optional[Name] = Optional.Absent,
    owner: Optional[Owner] = Optional.Absent,
    providerType: Optional[zio.aws.codegurureviewer.model.ProviderType] =
      Optional.Absent,
    state: Optional[zio.aws.codegurureviewer.model.JobState] = Optional.Absent,
    createdTimeStamp: Optional[TimeStamp] = Optional.Absent,
    lastUpdatedTimeStamp: Optional[TimeStamp] = Optional.Absent,
    `type`: Optional[zio.aws.codegurureviewer.model.Type] = Optional.Absent,
    pullRequestId: Optional[PullRequestId] = Optional.Absent,
    metricsSummary: Optional[zio.aws.codegurureviewer.model.MetricsSummary] =
      Optional.Absent,
    sourceCodeType: Optional[zio.aws.codegurureviewer.model.SourceCodeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary = {
    import CodeReviewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        codeReviewArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.codeReviewArn)
      .optionallyWith(
        repositoryName.map(value => Name.unwrap(value): java.lang.String)
      )(_.repositoryName)
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(metricsSummary.map(value => value.buildAwsValue()))(
        _.metricsSummary
      )
      .optionallyWith(sourceCodeType.map(value => value.buildAwsValue()))(
        _.sourceCodeType
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly =
    zio.aws.codegurureviewer.model.CodeReviewSummary.wrap(buildAwsValue())
}
object CodeReviewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeReviewSummary =
      zio.aws.codegurureviewer.model.CodeReviewSummary(
        name.map(value => value),
        codeReviewArn.map(value => value),
        repositoryName.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value),
        createdTimeStamp.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        `type`.map(value => value),
        pullRequestId.map(value => value),
        metricsSummary.map(value => value.asEditable),
        sourceCodeType.map(value => value.asEditable)
      )
    def name: Optional[Name]
    def codeReviewArn: Optional[Arn]
    def repositoryName: Optional[Name]
    def owner: Optional[Owner]
    def providerType: Optional[zio.aws.codegurureviewer.model.ProviderType]
    def state: Optional[zio.aws.codegurureviewer.model.JobState]
    def createdTimeStamp: Optional[TimeStamp]
    def lastUpdatedTimeStamp: Optional[TimeStamp]
    def `type`: Optional[zio.aws.codegurureviewer.model.Type]
    def pullRequestId: Optional[PullRequestId]
    def metricsSummary
        : Optional[zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly]
    def sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCodeReviewArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("codeReviewArn", codeReviewArn)
    def getRepositoryName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.JobState] =
      AwsError.unwrapOptionField("state", state)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getType: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getMetricsSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("metricsSummary", metricsSummary)
    def getSourceCodeType: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("sourceCodeType", sourceCodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary
  ) extends zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val codeReviewArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.codeReviewArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val repositoryName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryName())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Optional[Owner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Optional[zio.aws.codegurureviewer.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state: Optional[zio.aws.codegurureviewer.model.JobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.codegurureviewer.model.JobState.wrap(value))
    override val createdTimeStamp: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val lastUpdatedTimeStamp: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimeStamp())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.TimeStamp(value)
        )
    override val `type`: Optional[zio.aws.codegurureviewer.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codegurureviewer.model.Type.wrap(value))
    override val pullRequestId: Optional[PullRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.PullRequestId(value)
      )
    override val metricsSummary
        : Optional[zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsSummary())
        .map(value => zio.aws.codegurureviewer.model.MetricsSummary.wrap(value))
    override val sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeType())
        .map(value => zio.aws.codegurureviewer.model.SourceCodeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReviewSummary
  ): zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly = new Wrapper(
    impl
  )
}
