package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.BranchName
import scala.jdk.CollectionConverters._
final case class RepositoryHeadSourceCodeType(branchName: BranchName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType = {
    import RepositoryHeadSourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType
      .builder()
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType
      .wrap(buildAwsValue())
}
object RepositoryHeadSourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType =
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType(branchName)
    def branchName: BranchName
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType
  ) extends zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly {
    override val branchName: BranchName =
      zio.aws.codegurureviewer.model.primitives.BranchName(impl.branchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType
  ): zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly =
    new Wrapper(impl)
}
