package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.CommitId
import scala.jdk.CollectionConverters._
final case class CommitDiffSourceCodeType(
    sourceCommit: Optional[CommitId] = Optional.Absent,
    destinationCommit: Optional[CommitId] = Optional.Absent,
    mergeBaseCommit: Optional[CommitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType = {
    import CommitDiffSourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
      .builder()
      .optionallyWith(
        sourceCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.sourceCommit)
      .optionallyWith(
        destinationCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.destinationCommit)
      .optionallyWith(
        mergeBaseCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBaseCommit)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.CommitDiffSourceCodeType
      .wrap(buildAwsValue())
}
object CommitDiffSourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CommitDiffSourceCodeType =
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType(
        sourceCommit.map(value => value),
        destinationCommit.map(value => value),
        mergeBaseCommit.map(value => value)
      )
    def sourceCommit: Optional[CommitId]
    def destinationCommit: Optional[CommitId]
    def mergeBaseCommit: Optional[CommitId]
    def getSourceCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("sourceCommit", sourceCommit)
    def getDestinationCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("destinationCommit", destinationCommit)
    def getMergeBaseCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBaseCommit", mergeBaseCommit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ) extends zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly {
    override val sourceCommit: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
    override val destinationCommit: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
    override val mergeBaseCommit: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.mergeBaseCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ): zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly =
    new Wrapper(impl)
}
