package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  AssociationId,
  Owner,
  StateReason,
  Arn,
  ConnectionArn,
  TimeStamp,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RepositoryAssociation(
    associationId: Optional[AssociationId] = Optional.Absent,
    associationArn: Optional[Arn] = Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    owner: Optional[Owner] = Optional.Absent,
    providerType: Optional[zio.aws.codegurureviewer.model.ProviderType] =
      Optional.Absent,
    state: Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      Optional.Absent,
    stateReason: Optional[StateReason] = Optional.Absent,
    lastUpdatedTimeStamp: Optional[TimeStamp] = Optional.Absent,
    createdTimeStamp: Optional[TimeStamp] = Optional.Absent,
    kmsKeyDetails: Optional[zio.aws.codegurureviewer.model.KMSKeyDetails] =
      Optional.Absent,
    s3RepositoryDetails: Optional[
      zio.aws.codegurureviewer.model.S3RepositoryDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation = {
    import RepositoryAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.associationArn)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(kmsKeyDetails.map(value => value.buildAwsValue()))(
        _.kmsKeyDetails
      )
      .optionallyWith(s3RepositoryDetails.map(value => value.buildAwsValue()))(
        _.s3RepositoryDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryAssociation.wrap(buildAwsValue())
}
object RepositoryAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RepositoryAssociation =
      zio.aws.codegurureviewer.model.RepositoryAssociation(
        associationId.map(value => value),
        associationArn.map(value => value),
        connectionArn.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        createdTimeStamp.map(value => value),
        kmsKeyDetails.map(value => value.asEditable),
        s3RepositoryDetails.map(value => value.asEditable)
      )
    def associationId: Optional[AssociationId]
    def associationArn: Optional[Arn]
    def connectionArn: Optional[ConnectionArn]
    def name: Optional[Name]
    def owner: Optional[Owner]
    def providerType: Optional[zio.aws.codegurureviewer.model.ProviderType]
    def state
        : Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    def stateReason: Optional[StateReason]
    def lastUpdatedTimeStamp: Optional[TimeStamp]
    def createdTimeStamp: Optional[TimeStamp]
    def kmsKeyDetails
        : Optional[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly]
    def s3RepositoryDetails
        : Optional[zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ] = AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getKmsKeyDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKeyDetails", kmsKeyDetails)
    def getS3RepositoryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3RepositoryDetails", s3RepositoryDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ) extends zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.AssociationId(value)
      )
    override val associationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.associationArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ConnectionArn(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Optional[Owner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Optional[zio.aws.codegurureviewer.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state
        : Optional[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(value)
        )
    override val stateReason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.StateReason(value)
      )
    override val lastUpdatedTimeStamp: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimeStamp())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.TimeStamp(value)
        )
    override val createdTimeStamp: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val kmsKeyDetails
        : Optional[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyDetails())
        .map(value => zio.aws.codegurureviewer.model.KMSKeyDetails.wrap(value))
    override val s3RepositoryDetails: Optional[
      zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3RepositoryDetails())
      .map(value =>
        zio.aws.codegurureviewer.model.S3RepositoryDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ): zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly =
    new Wrapper(impl)
}
