package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  TimeStamp,
  UserId,
  RecommendationId,
  Arn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RecommendationFeedback(
    codeReviewArn: Optional[Arn] = Optional.Absent,
    recommendationId: Optional[RecommendationId] = Optional.Absent,
    reactions: Optional[Iterable[zio.aws.codegurureviewer.model.Reaction]] =
      Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    createdTimeStamp: Optional[TimeStamp] = Optional.Absent,
    lastUpdatedTimeStamp: Optional[TimeStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedback = {
    import RecommendationFeedback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedback
      .builder()
      .optionallyWith(
        codeReviewArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.codeReviewArn)
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationId.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .optionallyWith(
        reactions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reactionsWithStrings)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly =
    zio.aws.codegurureviewer.model.RecommendationFeedback.wrap(buildAwsValue())
}
object RecommendationFeedback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RecommendationFeedback =
      zio.aws.codegurureviewer.model.RecommendationFeedback(
        codeReviewArn.map(value => value),
        recommendationId.map(value => value),
        reactions.map(value => value),
        userId.map(value => value),
        createdTimeStamp.map(value => value),
        lastUpdatedTimeStamp.map(value => value)
      )
    def codeReviewArn: Optional[Arn]
    def recommendationId: Optional[RecommendationId]
    def reactions: Optional[List[zio.aws.codegurureviewer.model.Reaction]]
    def userId: Optional[UserId]
    def createdTimeStamp: Optional[TimeStamp]
    def lastUpdatedTimeStamp: Optional[TimeStamp]
    def getCodeReviewArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("codeReviewArn", codeReviewArn)
    def getRecommendationId: ZIO[Any, AwsError, RecommendationId] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getReactions
        : ZIO[Any, AwsError, List[zio.aws.codegurureviewer.model.Reaction]] =
      AwsError.unwrapOptionField("reactions", reactions)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedback
  ) extends zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly {
    override val codeReviewArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.codeReviewArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val recommendationId: Optional[RecommendationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationId())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.RecommendationId(value)
        )
    override val reactions
        : Optional[List[zio.aws.codegurureviewer.model.Reaction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reactions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.Reaction.wrap(item)
          }.toList
        )
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.codegurureviewer.model.primitives.UserId(value))
    override val createdTimeStamp: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val lastUpdatedTimeStamp: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimeStamp())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.TimeStamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedback
  ): zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly =
    new Wrapper(impl)
}
