package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{
  FindingsCount,
  MeteredLinesOfCodeCount
}
import scala.jdk.CollectionConverters._
final case class MetricsSummary(
    meteredLinesOfCodeCount: Optional[MeteredLinesOfCodeCount] =
      Optional.Absent,
    findingsCount: Optional[FindingsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary = {
    import MetricsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary
      .builder()
      .optionallyWith(
        meteredLinesOfCodeCount.map(value =>
          MeteredLinesOfCodeCount.unwrap(value): java.lang.Long
        )
      )(_.meteredLinesOfCodeCount)
      .optionallyWith(
        findingsCount.map(value => FindingsCount.unwrap(value): java.lang.Long)
      )(_.findingsCount)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly =
    zio.aws.codegurureviewer.model.MetricsSummary.wrap(buildAwsValue())
}
object MetricsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.MetricsSummary =
      zio.aws.codegurureviewer.model.MetricsSummary(
        meteredLinesOfCodeCount.map(value => value),
        findingsCount.map(value => value)
      )
    def meteredLinesOfCodeCount: Optional[MeteredLinesOfCodeCount]
    def findingsCount: Optional[FindingsCount]
    def getMeteredLinesOfCodeCount
        : ZIO[Any, AwsError, MeteredLinesOfCodeCount] = AwsError
      .unwrapOptionField("meteredLinesOfCodeCount", meteredLinesOfCodeCount)
    def getFindingsCount: ZIO[Any, AwsError, FindingsCount] =
      AwsError.unwrapOptionField("findingsCount", findingsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary
  ) extends zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly {
    override val meteredLinesOfCodeCount: Optional[MeteredLinesOfCodeCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meteredLinesOfCodeCount())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives
            .MeteredLinesOfCodeCount(value)
        )
    override val findingsCount: Optional[FindingsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.findingsCount())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.FindingsCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary
  ): zio.aws.codegurureviewer.model.MetricsSummary.ReadOnly = new Wrapper(impl)
}
