package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters._
sealed trait JobState {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.JobState
}
object JobState {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.JobState
  ): zio.aws.codegurureviewer.model.JobState = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.JobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.JobState.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.codegurureviewer.model.JobState.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.codegurureviewer.model.JobState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codegurureviewer.model.JobState.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.JobState =
      software.amazon.awssdk.services.codegurureviewer.model.JobState.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed extends zio.aws.codegurureviewer.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.JobState =
      software.amazon.awssdk.services.codegurureviewer.model.JobState.COMPLETED
  }
  case object Pending extends zio.aws.codegurureviewer.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.JobState =
      software.amazon.awssdk.services.codegurureviewer.model.JobState.PENDING
  }
  case object Failed extends zio.aws.codegurureviewer.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.JobState =
      software.amazon.awssdk.services.codegurureviewer.model.JobState.FAILED
  }
  case object Deleting extends zio.aws.codegurureviewer.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.JobState =
      software.amazon.awssdk.services.codegurureviewer.model.JobState.DELETING
  }
}
