package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationCategory {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory
}
object RecommendationCategory {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory
  ): zio.aws.codegurureviewer.model.RecommendationCategory = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.AWS_BEST_PRACTICES =>
      val r = AWSBestPractices
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.AWS_CLOUD_FORMATION_ISSUES =>
      val r = AWSCloudFormationIssues
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.DUPLICATE_CODE =>
      val r = DuplicateCode
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CODE_MAINTENANCE_ISSUES =>
      val r = CodeMaintenanceIssues
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CONCURRENCY_ISSUES =>
      val r = ConcurrencyIssues
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.INPUT_VALIDATIONS =>
      val r = InputValidations
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.PYTHON_BEST_PRACTICES =>
      val r = PythonBestPractices
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.JAVA_BEST_PRACTICES =>
      val r = JavaBestPractices
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.RESOURCE_LEAKS =>
      val r = ResourceLeaks
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.SECURITY_ISSUES =>
      val r = SecurityIssues
      r
    case software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CODE_INCONSISTENCIES =>
      val r = CodeInconsistencies
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object AWSBestPractices
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.AWS_BEST_PRACTICES
  }
  case object AWSCloudFormationIssues
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.AWS_CLOUD_FORMATION_ISSUES
  }
  case object DuplicateCode
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.DUPLICATE_CODE
  }
  case object CodeMaintenanceIssues
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CODE_MAINTENANCE_ISSUES
  }
  case object ConcurrencyIssues
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CONCURRENCY_ISSUES
  }
  case object InputValidations
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.INPUT_VALIDATIONS
  }
  case object PythonBestPractices
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.PYTHON_BEST_PRACTICES
  }
  case object JavaBestPractices
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.JAVA_BEST_PRACTICES
  }
  case object ResourceLeaks
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.RESOURCE_LEAKS
  }
  case object SecurityIssues
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.SECURITY_ISSUES
  }
  case object CodeInconsistencies
      extends zio.aws.codegurureviewer.model.RecommendationCategory {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory =
      software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory.CODE_INCONSISTENCIES
  }
}
