package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.{RecommendationId, Arn}
import scala.jdk.CollectionConverters._
final case class PutRecommendationFeedbackRequest(
    codeReviewArn: Arn,
    recommendationId: RecommendationId,
    reactions: Iterable[zio.aws.codegurureviewer.model.Reaction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest = {
    import PutRecommendationFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest
      .builder()
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .recommendationId(
        RecommendationId.unwrap(recommendationId): java.lang.String
      )
      .reactionsWithStrings(reactions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest.ReadOnly =
    zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest
      .wrap(buildAwsValue())
}
object PutRecommendationFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest =
      zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest(
        codeReviewArn,
        recommendationId,
        reactions
      )
    def codeReviewArn: Arn
    def recommendationId: RecommendationId
    def reactions: List[zio.aws.codegurureviewer.model.Reaction]
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
    def getRecommendationId: ZIO[Any, Nothing, RecommendationId] =
      ZIO.succeed(recommendationId)
    def getReactions
        : ZIO[Any, Nothing, List[zio.aws.codegurureviewer.model.Reaction]] =
      ZIO.succeed(reactions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest
  ) extends zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest.ReadOnly {
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
    override val recommendationId: RecommendationId =
      zio.aws.codegurureviewer.model.primitives
        .RecommendationId(impl.recommendationId())
    override val reactions: List[zio.aws.codegurureviewer.model.Reaction] = impl
      .reactions()
      .asScala
      .map { item =>
        zio.aws.codegurureviewer.model.Reaction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest
  ): zio.aws.codegurureviewer.model.PutRecommendationFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
