package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codegurureviewer.model.primitives.{
  AssociationId,
  Owner,
  Arn,
  ConnectionArn,
  TimeStamp,
  Name
}
import scala.jdk.CollectionConverters._
final case class RepositoryAssociationSummary(
    associationArn: Option[Arn] = None,
    connectionArn: Option[ConnectionArn] = None,
    lastUpdatedTimeStamp: Option[TimeStamp] = None,
    associationId: Option[AssociationId] = None,
    name: Option[Name] = None,
    owner: Option[Owner] = None,
    providerType: Option[zio.aws.codegurureviewer.model.ProviderType] = None,
    state: Option[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary = {
    import RepositoryAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
      .builder()
      .optionallyWith(
        associationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.associationArn)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryAssociationSummary
      .wrap(buildAwsValue())
}
object RepositoryAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.RepositoryAssociationSummary =
      zio.aws.codegurureviewer.model.RepositoryAssociationSummary(
        associationArn.map(value => value),
        connectionArn.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        associationId.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value)
      )
    def associationArn: Option[Arn]
    def connectionArn: Option[ConnectionArn]
    def lastUpdatedTimeStamp: Option[TimeStamp]
    def associationId: Option[AssociationId]
    def name: Option[Name]
    def owner: Option[Owner]
    def providerType: Option[zio.aws.codegurureviewer.model.ProviderType]
    def state: Option[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    def getAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ) extends zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly {
    override val associationArn: Option[Arn] = scala
      .Option(impl.associationArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val connectionArn: Option[ConnectionArn] = scala
      .Option(impl.connectionArn())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ConnectionArn(value)
      )
    override val lastUpdatedTimeStamp: Option[TimeStamp] = scala
      .Option(impl.lastUpdatedTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.AssociationId(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Option[Owner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Option[zio.aws.codegurureviewer.model.ProviderType] = scala
      .Option(impl.providerType())
      .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state
        : Option[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary
  ): zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly =
    new Wrapper(impl)
}
