package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters._
sealed trait ProviderType {
  def unwrap
      : software.amazon.awssdk.services.codegurureviewer.model.ProviderType
}
object ProviderType {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.ProviderType
  ): zio.aws.codegurureviewer.model.ProviderType = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.CODE_COMMIT =>
      val r = CodeCommit
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.GIT_HUB =>
      val r = GitHub
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.BITBUCKET =>
      val r = Bitbucket
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.GIT_HUB_ENTERPRISE_SERVER =>
      val r = GitHubEnterpriseServer
      r
    case software.amazon.awssdk.services.codegurureviewer.model.ProviderType.S3_BUCKET =>
      val r = S3Bucket
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object CodeCommit extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.CODE_COMMIT
  }
  case object GitHub extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.GIT_HUB
  }
  case object Bitbucket extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.BITBUCKET
  }
  case object GitHubEnterpriseServer
      extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.GIT_HUB_ENTERPRISE_SERVER
  }
  case object S3Bucket extends zio.aws.codegurureviewer.model.ProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.ProviderType =
      software.amazon.awssdk.services.codegurureviewer.model.ProviderType.S3_BUCKET
  }
}
