package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class S3BucketRepository(
    name: Name,
    details: Option[zio.aws.codegurureviewer.model.S3RepositoryDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository = {
    import S3BucketRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly =
    zio.aws.codegurureviewer.model.S3BucketRepository.wrap(buildAwsValue())
}
object S3BucketRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.S3BucketRepository =
      zio.aws.codegurureviewer.model
        .S3BucketRepository(name, details.map(value => value.asEditable))
    def name: Name
    def details
        : Option[zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository
  ) extends zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly {
    override val name: Name =
      zio.aws.codegurureviewer.model.primitives.Name(impl.name())
    override val details
        : Option[zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly] =
      scala
        .Option(impl.details())
        .map(value =>
          zio.aws.codegurureviewer.model.S3RepositoryDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository
  ): zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly = new Wrapper(
    impl
  )
}
