package zio.aws.codegurureviewer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  NextToken,
  MaxResults,
  Owner,
  Name
}
import scala.jdk.CollectionConverters._
final case class ListRepositoryAssociationsRequest(
    providerTypes: Option[
      Iterable[zio.aws.codegurureviewer.model.ProviderType]
    ] = None,
    states: Option[
      Iterable[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ] = None,
    names: Option[Iterable[Name]] = None,
    owners: Option[Iterable[Owner]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest = {
    import ListRepositoryAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
      .builder()
      .optionallyWith(
        providerTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.providerTypesWithStrings)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            Owner.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest
      .wrap(buildAwsValue())
}
object ListRepositoryAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest =
      zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest(
        providerTypes.map(value => value),
        states.map(value => value),
        names.map(value => value),
        owners.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def providerTypes: Option[List[zio.aws.codegurureviewer.model.ProviderType]]
    def states: Option[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ]
    def names: Option[List[Name]]
    def owners: Option[List[Owner]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getProviderTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.ProviderType
    ]] = AwsError.unwrapOptionField("providerTypes", providerTypes)
    def getStates: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ]] = AwsError.unwrapOptionField("states", states)
    def getNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("names", names)
    def getOwners: ZIO[Any, AwsError, List[Owner]] =
      AwsError.unwrapOptionField("owners", owners)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ) extends zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly {
    override val providerTypes
        : Option[List[zio.aws.codegurureviewer.model.ProviderType]] = scala
      .Option(impl.providerTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.ProviderType.wrap(item)
        }.toList
      )
    override val states: Option[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(item)
        }.toList
      )
    override val names: Option[List[Name]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.Name(item)
        }.toList
      )
    override val owners: Option[List[Owner]] = scala
      .Option(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.Owner(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codegurureviewer.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ): zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
