package zio.aws.codegurureviewer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  NextToken,
  UserId,
  RecommendationId,
  Arn,
  MaxResults
}
import scala.jdk.CollectionConverters._
final case class ListRecommendationFeedbackRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    codeReviewArn: Arn,
    userIds: Option[Iterable[UserId]] = None,
    recommendationIds: Option[Iterable[RecommendationId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest = {
    import ListRecommendationFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        recommendationIds.map(value =>
          value.map { item =>
            RecommendationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recommendationIds)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest
      .wrap(buildAwsValue())
}
object ListRecommendationFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest =
      zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        codeReviewArn,
        userIds.map(value => value),
        recommendationIds.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def codeReviewArn: Arn
    def userIds: Option[List[UserId]]
    def recommendationIds: Option[List[RecommendationId]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getRecommendationIds: ZIO[Any, AwsError, List[RecommendationId]] =
      AwsError.unwrapOptionField("recommendationIds", recommendationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ) extends zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codegurureviewer.model.primitives.MaxResults(value))
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
    override val userIds: Option[List[UserId]] = scala
      .Option(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.UserId(item)
        }.toList
      )
    override val recommendationIds: Option[List[RecommendationId]] = scala
      .Option(impl.recommendationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.RecommendationId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ): zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
