package zio.aws.codegurureviewer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{
  NextToken,
  ListCodeReviewsMaxResults,
  Name
}
import scala.jdk.CollectionConverters._
final case class ListCodeReviewsRequest(
    providerTypes: Option[
      Iterable[zio.aws.codegurureviewer.model.ProviderType]
    ] = None,
    states: Option[Iterable[zio.aws.codegurureviewer.model.JobState]] = None,
    repositoryNames: Option[Iterable[Name]] = None,
    `type`: zio.aws.codegurureviewer.model.Type,
    maxResults: Option[ListCodeReviewsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest = {
    import ListCodeReviewsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest
      .builder()
      .optionallyWith(
        providerTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.providerTypesWithStrings)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        repositoryNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.repositoryNames)
      .`type`(`type`.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          ListCodeReviewsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListCodeReviewsRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListCodeReviewsRequest.wrap(buildAwsValue())
}
object ListCodeReviewsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListCodeReviewsRequest =
      zio.aws.codegurureviewer.model.ListCodeReviewsRequest(
        providerTypes.map(value => value),
        states.map(value => value),
        repositoryNames.map(value => value),
        `type`,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def providerTypes: Option[List[zio.aws.codegurureviewer.model.ProviderType]]
    def states: Option[List[zio.aws.codegurureviewer.model.JobState]]
    def repositoryNames: Option[List[Name]]
    def `type`: zio.aws.codegurureviewer.model.Type
    def maxResults: Option[ListCodeReviewsMaxResults]
    def nextToken: Option[NextToken]
    def getProviderTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.ProviderType
    ]] = AwsError.unwrapOptionField("providerTypes", providerTypes)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.codegurureviewer.model.JobState]] =
      AwsError.unwrapOptionField("states", states)
    def getRepositoryNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("repositoryNames", repositoryNames)
    def getType: ZIO[Any, Nothing, zio.aws.codegurureviewer.model.Type] =
      ZIO.succeed(`type`)
    def getMaxResults: ZIO[Any, AwsError, ListCodeReviewsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest
  ) extends zio.aws.codegurureviewer.model.ListCodeReviewsRequest.ReadOnly {
    override val providerTypes
        : Option[List[zio.aws.codegurureviewer.model.ProviderType]] = scala
      .Option(impl.providerTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.ProviderType.wrap(item)
        }.toList
      )
    override val states: Option[List[zio.aws.codegurureviewer.model.JobState]] =
      scala
        .Option(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.JobState.wrap(item)
          }.toList
        )
    override val repositoryNames: Option[List[Name]] = scala
      .Option(impl.repositoryNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.Name(item)
        }.toList
      )
    override val `type`: zio.aws.codegurureviewer.model.Type =
      zio.aws.codegurureviewer.model.Type.wrap(impl.`type`())
    override val maxResults: Option[ListCodeReviewsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives
          .ListCodeReviewsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest
  ): zio.aws.codegurureviewer.model.ListCodeReviewsRequest.ReadOnly =
    new Wrapper(impl)
}
