package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.CommitId
import scala.jdk.CollectionConverters._
final case class CommitDiffSourceCodeType(
    sourceCommit: Option[CommitId] = None,
    destinationCommit: Option[CommitId] = None,
    mergeBaseCommit: Option[CommitId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType = {
    import CommitDiffSourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
      .builder()
      .optionallyWith(
        sourceCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.sourceCommit)
      .optionallyWith(
        destinationCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.destinationCommit)
      .optionallyWith(
        mergeBaseCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBaseCommit)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.CommitDiffSourceCodeType
      .wrap(buildAwsValue())
}
object CommitDiffSourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CommitDiffSourceCodeType =
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType(
        sourceCommit.map(value => value),
        destinationCommit.map(value => value),
        mergeBaseCommit.map(value => value)
      )
    def sourceCommit: Option[CommitId]
    def destinationCommit: Option[CommitId]
    def mergeBaseCommit: Option[CommitId]
    def getSourceCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("sourceCommit", sourceCommit)
    def getDestinationCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("destinationCommit", destinationCommit)
    def getMergeBaseCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBaseCommit", mergeBaseCommit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ) extends zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly {
    override val sourceCommit: Option[CommitId] = scala
      .Option(impl.sourceCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
    override val destinationCommit: Option[CommitId] = scala
      .Option(impl.destinationCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
    override val mergeBaseCommit: Option[CommitId] = scala
      .Option(impl.mergeBaseCommit())
      .map(value => zio.aws.codegurureviewer.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType
  ): zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly =
    new Wrapper(impl)
}
