package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SourceCodeType(
    commitDiff: Option[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType
    ] = None,
    repositoryHead: Option[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType
    ] = None,
    branchDiff: Option[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType
    ] = None,
    s3BucketRepository: Option[
      zio.aws.codegurureviewer.model.S3BucketRepository
    ] = None,
    requestMetadata: Option[zio.aws.codegurureviewer.model.RequestMetadata] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType = {
    import SourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
      .builder()
      .optionallyWith(commitDiff.map(value => value.buildAwsValue()))(
        _.commitDiff
      )
      .optionallyWith(repositoryHead.map(value => value.buildAwsValue()))(
        _.repositoryHead
      )
      .optionallyWith(branchDiff.map(value => value.buildAwsValue()))(
        _.branchDiff
      )
      .optionallyWith(s3BucketRepository.map(value => value.buildAwsValue()))(
        _.s3BucketRepository
      )
      .optionallyWith(requestMetadata.map(value => value.buildAwsValue()))(
        _.requestMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.SourceCodeType.wrap(buildAwsValue())
}
object SourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.SourceCodeType =
      zio.aws.codegurureviewer.model.SourceCodeType(
        commitDiff.map(value => value.asEditable),
        repositoryHead.map(value => value.asEditable),
        branchDiff.map(value => value.asEditable),
        s3BucketRepository.map(value => value.asEditable),
        requestMetadata.map(value => value.asEditable)
      )
    def commitDiff: Option[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ]
    def repositoryHead: Option[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ]
    def branchDiff: Option[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ]
    def s3BucketRepository
        : Option[zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly]
    def requestMetadata
        : Option[zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly]
    def getCommitDiff: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("commitDiff", commitDiff)
    def getRepositoryHead: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryHead", repositoryHead)
    def getBranchDiff: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("branchDiff", branchDiff)
    def getS3BucketRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly
    ] = AwsError.unwrapOptionField("s3BucketRepository", s3BucketRepository)
    def getRequestMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("requestMetadata", requestMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ) extends zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly {
    override val commitDiff: Option[
      zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.ReadOnly
    ] = scala
      .Option(impl.commitDiff())
      .map(value =>
        zio.aws.codegurureviewer.model.CommitDiffSourceCodeType.wrap(value)
      )
    override val repositoryHead: Option[
      zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.ReadOnly
    ] = scala
      .Option(impl.repositoryHead())
      .map(value =>
        zio.aws.codegurureviewer.model.RepositoryHeadSourceCodeType.wrap(value)
      )
    override val branchDiff: Option[
      zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly
    ] = scala
      .Option(impl.branchDiff())
      .map(value =>
        zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.wrap(value)
      )
    override val s3BucketRepository
        : Option[zio.aws.codegurureviewer.model.S3BucketRepository.ReadOnly] =
      scala
        .Option(impl.s3BucketRepository())
        .map(value =>
          zio.aws.codegurureviewer.model.S3BucketRepository.wrap(value)
        )
    override val requestMetadata
        : Option[zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly] =
      scala
        .Option(impl.requestMetadata())
        .map(value =>
          zio.aws.codegurureviewer.model.RequestMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType
  ): zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly = new Wrapper(impl)
}
