package zio.aws.codegurureviewer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{Arn, MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListRecommendationsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    codeReviewArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest = {
    import ListRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationsRequest
      .wrap(buildAwsValue())
}
object ListRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListRecommendationsRequest =
      zio.aws.codegurureviewer.model.ListRecommendationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        codeReviewArn
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def codeReviewArn: Arn
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ) extends zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codegurureviewer.model.primitives.MaxResults(value))
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ): zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
