package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{Requester, RequestId}
import scala.jdk.CollectionConverters._
final case class RequestMetadata(
    requestId: Optional[RequestId] = Optional.Absent,
    requester: Optional[Requester] = Optional.Absent,
    eventInfo: Optional[zio.aws.codegurureviewer.model.EventInfo] =
      Optional.Absent,
    vendorName: Optional[zio.aws.codegurureviewer.model.VendorName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata = {
    import RequestMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
      .builder()
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        requester.map(value => Requester.unwrap(value): java.lang.String)
      )(_.requester)
      .optionallyWith(eventInfo.map(value => value.buildAwsValue()))(
        _.eventInfo
      )
      .optionallyWith(vendorName.map(value => value.unwrap))(_.vendorName)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly =
    zio.aws.codegurureviewer.model.RequestMetadata.wrap(buildAwsValue())
}
object RequestMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RequestMetadata =
      zio.aws.codegurureviewer.model.RequestMetadata(
        requestId.map(value => value),
        requester.map(value => value),
        eventInfo.map(value => value.asEditable),
        vendorName.map(value => value)
      )
    def requestId: Optional[RequestId]
    def requester: Optional[Requester]
    def eventInfo: Optional[zio.aws.codegurureviewer.model.EventInfo.ReadOnly]
    def vendorName: Optional[zio.aws.codegurureviewer.model.VendorName]
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getRequester: ZIO[Any, AwsError, Requester] =
      AwsError.unwrapOptionField("requester", requester)
    def getEventInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.EventInfo.ReadOnly
    ] = AwsError.unwrapOptionField("eventInfo", eventInfo)
    def getVendorName
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.VendorName] =
      AwsError.unwrapOptionField("vendorName", vendorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ) extends zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly {
    override val requestId: Optional[RequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.codegurureviewer.model.primitives.RequestId(value))
    override val requester: Optional[Requester] = zio.aws.core.internal
      .optionalFromNullable(impl.requester())
      .map(value => zio.aws.codegurureviewer.model.primitives.Requester(value))
    override val eventInfo
        : Optional[zio.aws.codegurureviewer.model.EventInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventInfo())
        .map(value => zio.aws.codegurureviewer.model.EventInfo.wrap(value))
    override val vendorName
        : Optional[zio.aws.codegurureviewer.model.VendorName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorName())
        .map(value => zio.aws.codegurureviewer.model.VendorName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata
  ): zio.aws.codegurureviewer.model.RequestMetadata.ReadOnly = new Wrapper(impl)
}
