package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class CodeCommitRepository(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository = {
    import CodeCommitRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly =
    zio.aws.codegurureviewer.model.CodeCommitRepository.wrap(buildAwsValue())
}
object CodeCommitRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeCommitRepository =
      zio.aws.codegurureviewer.model.CodeCommitRepository(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository
  ) extends zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly {
    override val name: Name =
      zio.aws.codegurureviewer.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository
  ): zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly = new Wrapper(
    impl
  )
}
