package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codegurureviewer.model.primitives.{
  RuleTag,
  LongDescription,
  RuleId,
  RuleName,
  ShortDescription
}
import scala.jdk.CollectionConverters._
final case class RuleMetadata(
    ruleId: Optional[RuleId] = Optional.Absent,
    ruleName: Optional[RuleName] = Optional.Absent,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    longDescription: Optional[LongDescription] = Optional.Absent,
    ruleTags: Optional[Iterable[RuleTag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata = {
    import RuleMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
      .builder()
      .optionallyWith(
        ruleId.map(value => RuleId.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .optionallyWith(
        ruleTags.map(value =>
          value.map { item =>
            RuleTag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleTags)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly =
    zio.aws.codegurureviewer.model.RuleMetadata.wrap(buildAwsValue())
}
object RuleMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RuleMetadata =
      zio.aws.codegurureviewer.model.RuleMetadata(
        ruleId.map(value => value),
        ruleName.map(value => value),
        shortDescription.map(value => value),
        longDescription.map(value => value),
        ruleTags.map(value => value)
      )
    def ruleId: Optional[RuleId]
    def ruleName: Optional[RuleName]
    def shortDescription: Optional[ShortDescription]
    def longDescription: Optional[LongDescription]
    def ruleTags: Optional[List[RuleTag]]
    def getRuleId: ZIO[Any, AwsError, RuleId] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getRuleTags: ZIO[Any, AwsError, List[RuleTag]] =
      AwsError.unwrapOptionField("ruleTags", ruleTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ) extends zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly {
    override val ruleId: Optional[RuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.codegurureviewer.model.primitives.RuleId(value))
    override val ruleName: Optional[RuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.codegurureviewer.model.primitives.RuleName(value))
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.ShortDescription(value)
        )
    override val longDescription: Optional[LongDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longDescription())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.LongDescription(value)
        )
    override val ruleTags: Optional[List[RuleTag]] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.RuleTag(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata
  ): zio.aws.codegurureviewer.model.RuleMetadata.ReadOnly = new Wrapper(impl)
}
