package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  NextToken,
  UserId,
  RecommendationId,
  Arn,
  MaxResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecommendationFeedbackRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    codeReviewArn: Arn,
    userIds: Optional[Iterable[UserId]] = Optional.Absent,
    recommendationIds: Optional[Iterable[RecommendationId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest = {
    import ListRecommendationFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        recommendationIds.map(value =>
          value.map { item =>
            RecommendationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recommendationIds)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest
      .wrap(buildAwsValue())
}
object ListRecommendationFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest =
      zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        codeReviewArn,
        userIds.map(value => value),
        recommendationIds.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def codeReviewArn: Arn
    def userIds: Optional[List[UserId]]
    def recommendationIds: Optional[List[RecommendationId]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getRecommendationIds: ZIO[Any, AwsError, List[RecommendationId]] =
      AwsError.unwrapOptionField("recommendationIds", recommendationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ) extends zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codegurureviewer.model.primitives.MaxResults(value))
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
    override val userIds: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.UserId(item)
        }.toList
      )
    override val recommendationIds: Optional[List[RecommendationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.primitives.RecommendationId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest
  ): zio.aws.codegurureviewer.model.ListRecommendationFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
