package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  NextToken,
  MaxResults,
  Owner,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRepositoryAssociationsRequest(
    providerTypes: Optional[
      Iterable[zio.aws.codegurureviewer.model.ProviderType]
    ] = Optional.Absent,
    states: Optional[
      Iterable[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ] = Optional.Absent,
    names: Optional[Iterable[Name]] = Optional.Absent,
    owners: Optional[Iterable[Owner]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest = {
    import ListRepositoryAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
      .builder()
      .optionallyWith(
        providerTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.providerTypesWithStrings)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            Owner.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest
      .wrap(buildAwsValue())
}
object ListRepositoryAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest =
      zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest(
        providerTypes.map(value => value),
        states.map(value => value),
        names.map(value => value),
        owners.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def providerTypes
        : Optional[List[zio.aws.codegurureviewer.model.ProviderType]]
    def states: Optional[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ]
    def names: Optional[List[Name]]
    def owners: Optional[List[Owner]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getProviderTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.ProviderType
    ]] = AwsError.unwrapOptionField("providerTypes", providerTypes)
    def getStates: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ]] = AwsError.unwrapOptionField("states", states)
    def getNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("names", names)
    def getOwners: ZIO[Any, AwsError, List[Owner]] =
      AwsError.unwrapOptionField("owners", owners)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ) extends zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly {
    override val providerTypes
        : Optional[List[zio.aws.codegurureviewer.model.ProviderType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.ProviderType.wrap(item)
          }.toList
        )
    override val states: Optional[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.states())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(item)
        }.toList
      )
    override val names: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.Name(item)
        }.toList
      )
    override val owners: Optional[List[Owner]] = zio.aws.core.internal
      .optionalFromNullable(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.primitives.Owner(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codegurureviewer.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest
  ): zio.aws.codegurureviewer.model.ListRepositoryAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
