package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationFeedbackResponse(
    recommendationFeedback: Optional[
      zio.aws.codegurureviewer.model.RecommendationFeedback
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse = {
    import DescribeRecommendationFeedbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse
      .builder()
      .optionallyWith(
        recommendationFeedback.map(value => value.buildAwsValue())
      )(_.recommendationFeedback)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse
      .wrap(buildAwsValue())
}
object DescribeRecommendationFeedbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse =
      zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse(
        recommendationFeedback.map(value => value.asEditable)
      )
    def recommendationFeedback: Optional[
      zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly
    ]
    def getRecommendationFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationFeedback",
      recommendationFeedback
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse
  ) extends zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly {
    override val recommendationFeedback: Optional[
      zio.aws.codegurureviewer.model.RecommendationFeedback.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationFeedback())
      .map(value =>
        zio.aws.codegurureviewer.model.RecommendationFeedback.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse
  ): zio.aws.codegurureviewer.model.DescribeRecommendationFeedbackResponse.ReadOnly =
    new Wrapper(impl)
}
