package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters._
sealed trait AnalysisType {
  def unwrap
      : software.amazon.awssdk.services.codegurureviewer.model.AnalysisType
}
object AnalysisType {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.AnalysisType
  ): zio.aws.codegurureviewer.model.AnalysisType = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.SECURITY =>
      val r = Security
      r
    case software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.CODE_QUALITY =>
      val r = CodeQuality
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.AnalysisType =
      software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.UNKNOWN_TO_SDK_VERSION
  }
  case object Security extends zio.aws.codegurureviewer.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.AnalysisType =
      software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.SECURITY
  }
  case object CodeQuality extends zio.aws.codegurureviewer.model.AnalysisType {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.AnalysisType =
      software.amazon.awssdk.services.codegurureviewer.model.AnalysisType.CODE_QUALITY
  }
}
