package zio.aws.codegurureviewer.model
import scala.jdk.CollectionConverters._
sealed trait Reaction {
  def unwrap: software.amazon.awssdk.services.codegurureviewer.model.Reaction
}
object Reaction {
  def wrap(
      value: software.amazon.awssdk.services.codegurureviewer.model.Reaction
  ): zio.aws.codegurureviewer.model.Reaction = value match {
    case software.amazon.awssdk.services.codegurureviewer.model.Reaction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Reaction.THUMBS_UP =>
      val r = ThumbsUp
      r
    case software.amazon.awssdk.services.codegurureviewer.model.Reaction.THUMBS_DOWN =>
      val r = ThumbsDown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurureviewer.model.Reaction {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Reaction =
      software.amazon.awssdk.services.codegurureviewer.model.Reaction.UNKNOWN_TO_SDK_VERSION
  }
  case object ThumbsUp extends zio.aws.codegurureviewer.model.Reaction {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Reaction =
      software.amazon.awssdk.services.codegurureviewer.model.Reaction.THUMBS_UP
  }
  case object ThumbsDown extends zio.aws.codegurureviewer.model.Reaction {
    override def unwrap
        : software.amazon.awssdk.services.codegurureviewer.model.Reaction =
      software.amazon.awssdk.services.codegurureviewer.model.Reaction.THUMBS_DOWN
  }
}
