package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  Arn,
  ListRecommendationsMaxResults,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecommendationsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListRecommendationsMaxResults] = Optional.Absent,
    codeReviewArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest = {
    import ListRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListRecommendationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly =
    zio.aws.codegurureviewer.model.ListRecommendationsRequest
      .wrap(buildAwsValue())
}
object ListRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListRecommendationsRequest =
      zio.aws.codegurureviewer.model.ListRecommendationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        codeReviewArn
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListRecommendationsMaxResults]
    def codeReviewArn: Arn
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListRecommendationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ) extends zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
    override val maxResults: Optional[ListRecommendationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives
            .ListRecommendationsMaxResults(value)
        )
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest
  ): zio.aws.codegurureviewer.model.ListRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
